<!-- Modal Ubah User -->
<div class="modal fade" id="ubahJadwal{{ $item->id }}" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content shadow-lg border-0">

            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title">
                    <i class="fas fa-user-edit me-2"></i> Ubah Data
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form action="{{ route('admin.jadwal-shift.update', $item->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="modal-body">

                    <div class="mb-3">
                        <label for="departemen_id{{ $item->id }}" class="form-label">Nama Departemen</label>
                        <select name="departemen_id" id="departemen_id{{ $item->id }}" class="form-select" required>
                            <option value="" disabled>Pilih departemen....</option>
                            @foreach ($departemen as $list)
                                <option value="{{ $list->id }}"
                                    {{ $item->departemen_id == $list->id ? 'selected' : '' }}>
                                    {{ $list->nama }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="shift_id{{ $item->id }}" class="form-label">Shift</label>
                        <select name="shift_id" id="shift_id{{ $item->id }}" class="form-select" required>
                            <option value="" disabled>Pilih Jabatan....</option>
                            @foreach ($shift as $list)
                                <option value="{{ $list->id }}"
                                    {{ $item->shift_id == $list->id ? 'selected' : '' }}>
                                    {{ $list->kode }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Status</label>
                        <select name="status" class="form-select" required>
                            <option value="aktif" {{ $item->status == 'aktif' ? 'selected' : '' }}>Aktif</option>
                            <option value="nonaktif" {{ $item->status == 'nonaktif' ? 'selected' : '' }}>Nonaktif
                            </option>
                        </select>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Batal
                    </button>
                    <button type="submit" class="btn btn-warning">
                        Simpan Perubahan
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>
